# **App Name**: Inventory Insights

## Core Features:

- CSV Upload: Upload inventory data from a CSV file (Item Name, SKU, Category, Opening Stock, Purchase, Sales, Closing Stock, Cost Price, Selling Price, Reorder Level).
- Data Visualization: Display key performance indicators (KPIs) such as Product-wise Profit, Profit Margin, Top Products by Sales/Revenue, Inventory Health, Stock Values, Potential Profit, Reorder Alerts, Stock Movement, Fast vs Slow Movers, and Purchase to Sales Ratio, using interactive charts and tables.
- AI-Powered Data Analysis: Enable users to ask questions about their inventory data using natural language via a prompt window. Leverage the Gemini API as a tool to analyze the uploaded data and provide insightful responses.
- Reorder Alerts: Automatically identify and display items where Closing Stock is below the Reorder Level, triggering a reorder alert.
- Dynamic KPI Calculations: Automatically calculate KPIs based on the uploaded inventory data: Product-wise Profit, Profit Margin, Top Products by Sales/Revenue, Inventory Health, Stock Values, Potential Profit, Stock Movement %, Fast vs Slow Movers, Purchase to Sales Ratio.
- Light/Dark Mode Toggle: Implement a toggle button to switch between light and dark mode for improved user experience.
- User Authentication: User login and registration system with password requirements (minimum 6 characters, one uppercase, one special character), connected to a 'users' table in the 'aical2group' database.
- Change Password: Allow users to change their password within the application.

## Style Guidelines:

- Primary color: Deep indigo (#4B0082), reminiscent of knowledge, insight, and intelligence. Its visual character makes it more interesting than common blue shades. Its darkness fits with a dark scheme, but it's also vibrant enough for good contrast on a light background.
- Background color: Very dark desaturated indigo (#1A1423). It aligns visually to the primary color, and contributes to a sleek and professional dark mode design.
- Accent color: Purple (#800080) to complement the deep indigo and draw attention to key interactive elements.
- Body text: 'Inter', sans-serif.
- Headlines: 'Space Grotesk', sans-serif.
- Use modern, minimalist icons for dashboard elements, representing inventory metrics, and user actions.
- Subtle transitions and animations to enhance user engagement when displaying data visualizations or switching between views.
- Modern, professional, and sleek layout for a visually appealing dashboard.